
//Chris' WinGlide enhancements
//Copr. 1998, Chris Dohnal (cwdohnal@ucdavis.edu)

#include <windows.h>
#include "inifile.h"
#include "sysmenu.h"

BOOL CWGSubclassWindow(HWND, WNDPROC *, WNDPROC, DWORD);
BOOL CWGUnsubclassWindowIfSubclassed(VOID);
BOOL CWGUnsubclassWindowBecauseDestroyed(VOID);

static WNDPROC gpPrevWndProc = NULL;
static HWND ghSubclassedWnd = NULL;
static DWORD gdwSubclassedMode = WINGLIDE_MODE_NONE;
static BOOL gbAddedSystemMenuOptions = FALSE;
static BOOL gbAlteredWindowStyle = FALSE;
static LONG glOldWindowStyle;
static UINT guiPrevCloseMenuState;

static BOOL RedrawNonclientArea(HWND);


BOOL CWGSubclassWindow(HWND hWnd, WNDPROC *ppPrevWndProc, WNDPROC pSubclassWndProc, DWORD dwMode) {
	//Unsubclass the window and do other cleanup if it has already been subclassed
	if (gpPrevWndProc != NULL) {
		CWGUnsubclassWindowIfSubclassed();
	}

	//Subclass the window
	//Get the pointer to the previous window procedure
	gpPrevWndProc = (WNDPROC)GetWindowLong(hWnd, GWL_WNDPROC);
	if (gpPrevWndProc == NULL) {
		return FALSE;
	}

	//The pointer to the previous window procedure must be returned before setting the pointer
	//to the new window procedure
	*ppPrevWndProc = gpPrevWndProc;

	//Set the pointer to the new window procedure
	SetWindowLong(hWnd, GWL_WNDPROC, (LONG)pSubclassWndProc);

	//Save the handle of the subclassed window
	ghSubclassedWnd = hWnd;
	//Save the mode used when subclassing the window
	gdwSubclassedMode = dwMode;


	//Alter the window style if necessary
	gbAlteredWindowStyle = FALSE;
	switch (dwMode) {
	case WINGLIDE_MODE_STRETCH_BLT:
	case WINGLIDE_MODE_OVERLAY:
	case WINGLIDE_MODE_OFF_SCREEN_SURFACE:
		//Change the window style
		glOldWindowStyle = GetWindowLong(hWnd, GWL_STYLE);
		SetWindowLong(hWnd, GWL_STYLE, WS_OVERLAPPEDWINDOW);

		//Disable the close command on the system menu if the previous window style did not have a
		//system menu
		if (!(glOldWindowStyle & WS_SYSMENU)) {
			HMENU hMenu;

			hMenu = GetSystemMenu(hWnd, FALSE);
			guiPrevCloseMenuState = GetMenuState(hMenu, SC_CLOSE, 0);
			EnableMenuItem(hMenu, SC_CLOSE, MF_GRAYED);
		}
		
		//Resize the window so the image fits in the client area without stretching
		ResetWinGlideWindowSize(hWnd);

		//The window style has been altered
		gbAlteredWindowStyle = TRUE;

		break;

	case WINGLIDE_MODE_B2:
	default:
		;
	}

	//If system menu options are enabled, add options to the system menu
	gbAddedSystemMenuOptions = FALSE;
	if (gbSystemMenuOptions == TRUE) {
		//Add WinGlide options to the system menu
		AddWinGlideSystemMenuOptions(hWnd, dwMode);

		//Options have been added to the system menu
		gbAddedSystemMenuOptions = TRUE;
	}

	//Redraw the nonclient area of the window if necessary
	if (gbAlteredWindowStyle == TRUE) {
		RedrawNonclientArea(hWnd);
	}

	return TRUE;
}

BOOL CWGUnsubclassWindowIfSubclassed(VOID) {
	//Nothing to do if the window was not subclassed
	if (gpPrevWndProc == NULL) {
		return TRUE;
	}

	//If system menu options were enabled, remove them from the system menu
	if (gbAddedSystemMenuOptions == TRUE) {
		//Remove WinGlide options from the system menu
		RemoveWinGlideSystemMenuOptions(ghSubclassedWnd);
	}

	//If the window style was altered, restore it
	if (gbAlteredWindowStyle == TRUE) {
		//Restore the state of the close command on the system menu if it has been altered
		if (!(glOldWindowStyle & WS_SYSMENU)) {
			HMENU hMenu;

			hMenu = GetSystemMenu(ghSubclassedWnd, FALSE);
			EnableMenuItem(hMenu, SC_CLOSE, guiPrevCloseMenuState);
		}

		//Restore the old window style
		SetWindowLong(ghSubclassedWnd, GWL_STYLE, glOldWindowStyle);
	}

	//Unsubclass the window if it was subclassed
	//Since this function did not return before getting here, the window was subclassed
	SetWindowLong(ghSubclassedWnd, GWL_WNDPROC, (LONG)gpPrevWndProc);
	gpPrevWndProc = NULL;
	//Redraw the nonclient area of the window if necessary
	if (gbAlteredWindowStyle == TRUE) {
		RedrawNonclientArea(ghSubclassedWnd);
	}
	ghSubclassedWnd = NULL;
	gdwSubclassedMode = WINGLIDE_MODE_NONE;

	return TRUE;
}

BOOL CWGUnsubclassWindowBecauseDestroyed(VOID) {
	//It is not necessary to clean up the system menu or restore the window style because the
	//window is being destroyed anyway

	//Unsubclass the window because it is being destroyed
	SetWindowLong(ghSubclassedWnd, GWL_WNDPROC, (LONG)gpPrevWndProc);
	gpPrevWndProc = NULL;
	ghSubclassedWnd = NULL;
	gdwSubclassedMode = WINGLIDE_MODE_NONE;

	return TRUE;
}

static BOOL RedrawNonclientArea(HWND hWnd) {
	BOOL bRet;

	bRet = ShowWindow(hWnd, SW_SHOWNA);

	return bRet;
}

